<?php
session_start();

// Database connection details
$servername = "localhost";
$username = "root";
$password = ""; // Replace with your actual MySQL password
$dbname = "sports_warehouse"; // Make sure to replace this with your actual database name

// Create connection to the database
$conn = new mysqli($servername, $username, $password, $dbname);

// Check the connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Check if form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = trim($_POST['email']);
    $password = trim($_POST['password']);

    // Validate inputs
    if (empty($email) || empty($password)) {
        echo "Please enter both email and password.";
        exit;
    }

    // Check if the user exists in the database
    $sql = "SELECT * FROM users WHERE email = ?";
    $stmt = $conn->prepare($sql);
    
    if ($stmt === false) {
        die("Error preparing statement: " . $conn->error);
    }

    $stmt->bind_param("s", $email); // Bind the email to the query
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows == 1) {
        // User found, now check the password
        $user = $result->fetch_assoc();

        if (password_verify($password, $user['password'])) {
            // Password is correct, start the session and redirect to homepage
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['user_name'] = $user['name'];

            // Check if "Remember Me" is checked
            if (isset($_POST['remember-me'])) {
                setcookie("user_login", $email, time() + (86400 * 30), "/"); // 30 days expiry
            }

            header("Location: index.php"); // Redirect to homepage
            exit;
        } else {
            echo "Invalid password.";
        }
    } else {
        echo "No user found with that email.";
    }

    // Close the statement
    $stmt->close();
}

// Close the database connection
$conn->close();
?>
