<?php
// Database connection details
$servername = "localhost";
$username = "root";
$password = ""; // Replace with your actual MySQL password

// Create connection to MySQL server
$conn = new mysqli($servername, $username, $password);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// SQL to create the "sports_warehouse" database
$sql = "CREATE DATABASE IF NOT EXISTS sports_warehouse";
if ($conn->query($sql) === TRUE) {
    echo "Database 'sports_warehouse' created successfully.\n";
} else {
    die("Error creating database: " . $conn->error);
}

// Select the newly created database
$conn->select_db("sports_warehouse");

// Table creation queries

// 1. Users Table: For user registration, login, and role management
$sql = "CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    email VARCHAR(255) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    role ENUM('admin', 'customer') DEFAULT 'customer',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
)";
if ($conn->query($sql) === TRUE) {
    echo "Table 'users' created successfully.\n";
} else {
    die("Error creating table 'users': " . $conn->error);
}

// 2. Products Table: To store product information for the catalog
$sql = "CREATE TABLE IF NOT EXISTS products (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    description TEXT NOT NULL,
    price DECIMAL(10, 2) NOT NULL,
    stock INT DEFAULT 0,
    image VARCHAR(255),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
)";
if ($conn->query($sql) === TRUE) {
    echo "Table 'products' created successfully.\n";
} else {
    die("Error creating table 'products': " . $conn->error);
}

// 3. Shopping Cart Table: To store users' shopping cart data
$sql = "CREATE TABLE IF NOT EXISTS cart (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    product_id INT NOT NULL,
    quantity INT NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id),
    FOREIGN KEY (product_id) REFERENCES products(id)
)";
if ($conn->query($sql) === TRUE) {
    echo "Table 'cart' created successfully.\n";
} else {
    die("Error creating table 'cart': " . $conn->error);
}

// 4. Orders Table: To store completed orders after checkout
$sql = "CREATE TABLE IF NOT EXISTS orders (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    total_price DECIMAL(10, 2) NOT NULL,
    payment_status ENUM('pending', 'paid') DEFAULT 'pending',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id)
)";
if ($conn->query($sql) === TRUE) {
    echo "Table 'orders' created successfully.\n";
} else {
    die("Error creating table 'orders': " . $conn->error);
}

// 5. Order Items Table: To store details of each product in an order
$sql = "CREATE TABLE IF NOT EXISTS order_items (
    id INT AUTO_INCREMENT PRIMARY KEY,
    order_id INT NOT NULL,
    product_id INT NOT NULL,
    quantity INT NOT NULL,
    price DECIMAL(10, 2) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (order_id) REFERENCES orders(id),
    FOREIGN KEY (product_id) REFERENCES products(id)
)";
if ($conn->query($sql) === TRUE) {
    echo "Table 'order_items' created successfully.\n";
} else {
    die("Error creating table 'order_items': " . $conn->error);
}

// 6. Content Management Table: To store product-related content, blogs, announcements, etc.
$sql = "CREATE TABLE IF NOT EXISTS cms_content (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(255) NOT NULL,
    content TEXT NOT NULL,
    author_id INT NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (author_id) REFERENCES users(id)
)";
if ($conn->query($sql) === TRUE) {
    echo "Table 'cms_content' created successfully.\n";
} else {
    die("Error creating table 'cms_content': " . $conn->error);
}

// Close the connection
$conn->close();
?>